var wpsbc = jQuery.noConflict();
var $instance;
function htmlEscape(str) {
    return String(str)
            .replace(/&/g, '--AMP--')
            .replace(/"/g, '--DOUBLEQUOTE--')
            .replace(/'/g, '--QUOTE--')
            .replace(/</g, '--LT--')
            .replace(/>/g, '--GT--');
}
function showLoader(){
    wpsbc('.wpsbc-loading').fadeTo(0,0).css('display','block').fadeTo(200,1);
    wpsbc('.wpsbc-calendar ul').animate({
        'opacity' : '0.7'
    },200);
}
function hideLoader(){
    wpsbc('.wpsbc-loading').css('display','none');
}
function changeDay(direction, timestamp){
    var data = {
		action: 'changeDayAdmin',
        calendarDirection: direction,
		totalCalendars: $instance.find(".wpsbc-total-calendars").html(), 
        currentTimestamp: timestamp,
        calendarData: $instance.find(".wpsbc-calendar-data").html(),
        calendarHistory: $instance.find(".wpsbc-calendar-history").html(),
        calendarLegend: $instance.find(".wpsbc-calendar-legend").html(),
        showLegend: $instance.find(".wpsbc-show-legend").html(),
        showDropdown: $instance.find(".wpsbc-show-dropdown").html(),
        calendarLanguage: $instance.find(".wpsbc-calendar-language").html(),
        weekStart : $instance.find(".wpsbc-calendar-week-start").html(),
        calendarID : $instance.find(".wpsbc-calendar-ID").html()
        
	};
	wpsbc.post(ajaxurl, data, function(response) {
		$instance.find('.wpsbc-calendars').html(response);
        hideLoader();  
        wpsbc('.wpsbc-dropdown').customSelect();    
        wpsbc('.wpsbc-chosen').chosen(); 
	});
}

wpsbc(document).ready(function(){
    
    wpsbc('.wpsbc-chosen').chosen();
    
    wpsbc('.wpsbc-dropdown').customSelect();
    wpsbc('.wpsbc-container').each(function(){
    $instance = wpsbc(this);
    wpsbc($instance).on('change','.wpsbc-dropdown',function(e){
        showLoader();     
        e.preventDefault();        
        changeDay('jump',wpsbc(this).val())
    });
    
    wpsbc($instance).on('click','.wpsbc-prev',function(e){
        showLoader();
        e.preventDefault();
        if($instance.find(".wpsbc-current-timestamp a").length == 0)
            timestamp = $instance.find(".wpsbc-current-timestamp").html();
        else 
            timestamp = $instance.find(".wpsbc-current-timestamp a").html()   
        changeDay('prev',timestamp);
    });
    
    
    wpsbc($instance).on('click','.wpsbc-next',function(e){  
        showLoader();
        e.preventDefault();        
        if($instance.find(".wpsbc-current-timestamp a").length == 0)
            timestamp = $instance.find(".wpsbc-current-timestamp").html();
        else 
            timestamp = $instance.find(".wpsbc-current-timestamp a").html()   
        changeDay('next',timestamp);
    });
    
    })

    wpsbc(document).on('click',"#calendarBatchUpdate",function(e){
        e.preventDefault();
        var wpsbcCalendarData = JSON.parse(wpsbc(".wpsbc-calendar-data").html());  
        if (!wpsbcCalendarData) {
            wpsbcCalendarData = {};
        } 
        var currentTimestamp = wpsbc(".wpsbc-current-timestamp").html();
        var currentDate = new Date(currentTimestamp * 1000);
       
        var startDay = wpsbc("#startDay").val();
        var startMonth = wpsbc("#startMonth").val();
        var startYear = wpsbc("#startYear").val();
        
        var endDay = wpsbc("#endDay").val();
        var endMonth = wpsbc("#endMonth").val();
        var endYear = wpsbc("#endYear").val();
        
        var selectStatus = wpsbc("#changeStatus").val();
        
        var bookingDetails = wpsbc("#bookingDetails").val();

        var startTime = (Date.parse(startDay + " " + startMonth + " " + startYear))/1000;
        var endTime = (Date.parse(endDay + " " + endMonth + " " + endYear))/1000;
        if(startTime < endTime){
            for(i=startTime; i <= endTime + 60*60*23; i = i + 60*60*24){
                var changeDate = new Date(i * 1000);
                if(changeDate.getMonth() == currentDate.getMonth() && changeDate.getFullYear() == currentDate.getFullYear()){
                    if(!wpsbc("select.wpsbc-day-"+(changeDate.getDate())).find('option.wpsbc-option-' + selectStatus).prop('selected')){
                        wpsbc("select.wpsbc-day-"+(changeDate.getDate())).find('option').prop("selected",false);
                        wpsbc("select.wpsbc-day-"+(changeDate.getDate())).find('option.wpsbc-option-' + selectStatus).prop("selected",true);
                    }
                    wpsbc("select.wpsbc-day-"+(changeDate.getDate())).parent().find('span.wpsbc-select-status').removeClass().addClass('wpsbc-select-status status-' + selectStatus);
                    wpsbc("select.wpsbc-day-"+(changeDate.getDate())).parent().find('span.wpsbc-day-split-top').removeClass().addClass('wpsbc-day-split-top wpsbc-day-split-top-' + selectStatus);
                    wpsbc("select.wpsbc-day-"+(changeDate.getDate())).parent().find('span.wpsbc-day-split-bottom').removeClass().addClass('wpsbc-day-split-bottom wpsbc-day-split-bottom-' + selectStatus);
                    wpsbc("select.wpsbc-day-"+(changeDate.getDate())).parent().find(".wpsbc-input-description").val(bookingDetails);
                    
                    
                    wpsbc(".wpsbc-calendars li.wpsbc-day-" + changeDate.getDate()).removeClass().addClass('wpsbc-day wpsbc-day-' + changeDate.getDate() + ' status-' + selectStatus);
                    wpsbc(".wpsbc-calendars li.wpsbc-day-" + changeDate.getDate() + " span.wpsbc-day-split-top").removeClass().addClass('wpsbc-day-split-top wpsbc-day-split-top-' + selectStatus);
                    wpsbc(".wpsbc-calendars li.wpsbc-day-" + changeDate.getDate() + " span.wpsbc-day-split-bottom").removeClass().addClass('wpsbc-day-split-bottom wpsbc-day-split-bottom-' + selectStatus);
                    
                }
               
                var currentYear = 'year' + changeDate.getFullYear();
        		var currentMonth = 'month' + (changeDate.getMonth()+1);
        		var currentDay = 'day' + (changeDate.getDate());
                
                var currentTimestamp = wpsbc(".wpsbc-current-timestamp").html();
                var currentDate = new Date(currentTimestamp * 1000);
                var currentMonth = changeDate.getMonth()+1;
                var currentYear = changeDate.getFullYear();
                var currentDay = changeDate.getDate();
                
                
                if (!(currentYear in wpsbcCalendarData)) {
        			wpsbcCalendarData[currentYear] = {};
        		}
        		
        		if (!(currentMonth in wpsbcCalendarData[currentYear])) {
        			wpsbcCalendarData[currentYear][currentMonth] = {};
        		}
                wpsbcCalendarData[currentYear][currentMonth][currentDay] = selectStatus;
                wpsbcCalendarData[currentYear][currentMonth]['description-' + currentDay] = bookingDetails;
                
                wpsbc("span.error").css('display','none');
            }
        } else {
            wpsbc("span.error").css('display','block');
        }
        wpsbc(".wpsbc-calendar-data").html(JSON.stringify(wpsbcCalendarData));
        wpsbc("#inputCalendarData").val(JSON.stringify(wpsbcCalendarData));        
    })
    

    wpsbc(document).on('change',".wpsbc-day-select",function(e){
        var wpsbcCalendarData = JSON.parse(wpsbc(".wpsbc-calendar-data").html());  
        if (!wpsbcCalendarData) {
            wpsbcCalendarData = {};
        } 
        var currentTimestamp = wpsbc(".wpsbc-current-timestamp").html();
        var currentDate = new Date(currentTimestamp * 1000);
        var currentMonth = currentDate.getMonth()+1;
        var currentYear = currentDate.getFullYear();
        var currentDay = wpsbc(this).attr('name').replace('wpsbc-day-','');
        var selectStatus = wpsbc(this).val();
        
        if (!(currentYear in wpsbcCalendarData)) {
			wpsbcCalendarData[currentYear] = {};
		}
		
		if (!(currentMonth in wpsbcCalendarData[currentYear])) {
			wpsbcCalendarData[currentYear][currentMonth] = {};
		}
        wpsbcCalendarData[currentYear][currentMonth][currentDay] = selectStatus;

        //change colors
        wpsbc(this).parent().find('span.wpsbc-select-status').removeClass().addClass('wpsbc-select-status status-' + selectStatus);
        wpsbc(this).parent().find('span.wpsbc-day-split-top').removeClass().addClass('wpsbc-day-split-top wpsbc-day-split-top-' + selectStatus);
        wpsbc(this).parent().find('span.wpsbc-day-split-bottom').removeClass().addClass('wpsbc-day-split-bottom wpsbc-day-split-bottom-' + selectStatus);
        
        wpsbc(".wpsbc-calendar li.wpsbc-day-" + currentDay).removeClass().addClass('wpsbc-day wpsbc-day-' + currentDay + ' status-' + selectStatus);
        wpsbc(".wpsbc-calendar li.wpsbc-day-" + currentDay + " span.wpsbc-day-split-top").removeClass().addClass('wpsbc-day-split-top wpsbc-day-split-top-' + selectStatus);
        wpsbc(".wpsbc-calendar li.wpsbc-day-" + currentDay + " span.wpsbc-day-split-bottom").removeClass().addClass('wpsbc-day-split-bottom wpsbc-day-split-bottom-' + selectStatus);
        
        
        wpsbc(".wpsbc-calendar-data").html(JSON.stringify(wpsbcCalendarData));
        wpsbc("#inputCalendarData").val(JSON.stringify(wpsbcCalendarData));
       
    })
    
    
    
    wpsbc(document).on('keyup change click',".wpsbc-input-description",function(e){
        
        var wpsbcCalendarData = JSON.parse(wpsbc(".wpsbc-calendar-data").text());  
        if (!wpsbcCalendarData) {
            wpsbcCalendarData = {};
        } 
        var currentTimestamp = wpsbc(".wpsbc-current-timestamp").html();
        var currentDate = new Date(currentTimestamp * 1000);
        var currentMonth = currentDate.getMonth()+1;
        var currentYear = currentDate.getFullYear();
        var currentDay = wpsbc(this).attr('name').replace('wpsbc-description-','');
        var selectStatus = wpsbc(this).val();
        
        if (!(currentYear in wpsbcCalendarData)) {
			wpsbcCalendarData[currentYear] = {};
		}
		
		if (!(currentMonth in wpsbcCalendarData[currentYear])) {
			wpsbcCalendarData[currentYear][currentMonth] = {};
		}
        wpsbcCalendarData[currentYear][currentMonth]['description-' + currentDay] = htmlEscape(selectStatus);
        
        wpsbc(".wpsbc-calendar-data").text(JSON.stringify(wpsbcCalendarData));
        wpsbc("#inputCalendarData").val(JSON.stringify(wpsbcCalendarData));
       
    })
    
    wpsbc(".saveCalendar").click(function(){
        if (!wpsbc.trim(wpsbc(".fullTitle").val()).length) {
            wpsbc(".fullTitle").addClass('error').focus();
            return false;
        }
        return true;
        
    })
})
function wpsbc_select_text(containerid) {
    if (document.selection) {
        var range = document.body.createTextRange();
        range.moveToElementText(containerid);
        range.select();
    } else if (window.getSelection) {
        var range = document.createRange();
        range.selectNode(containerid);
        window.getSelection().addRange(range);
    }
}